﻿using System;
using System.IO;
using System.Data;
using System.Security;
using System.Security.Permissions;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Printing;
using System.Collections.Generic;
using Microsoft.Reporting.WinForms;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// VbecsReportPrinter
    /// </summary>
    public class VbecsReportPrinter : IDisposable
    {
        private int _currentPageIndex; 
        private IList<Stream> _streams;
        private bool _landscape;
        private string _printerName;
        private string _deviceInfo;
        private LocalReport _report;
        private PrinterSettings _printerSettings = null;

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="printerName"></param>
        /// <param name="landscape"></param>
        /// <param name="report"></param>
        public VbecsReportPrinter(string printerName, bool landscape, LocalReport report)
        {
            _printerName = printerName;
            _landscape = landscape;
            _report = report;

            if (landscape)
            {
                _deviceInfo = "<DeviceInfo>" +
                              "  <OutputFormat>EMF</OutputFormat>" +
                              "  <PageWidth>11in</PageWidth>" +
                              "  <PageHeight>8.5in</PageHeight>" +
                              "  <MarginTop>0.5in</MarginTop>" +
                              "  <MarginLeft>0.5in</MarginLeft>" +
                              "  <MarginRight>0.5in</MarginRight>" +
                              "  <MarginBottom>0.5in</MarginBottom>" +
                              "</DeviceInfo>";
            }
            else
            {
                if (_report.DisplayName == "BTRF")
                {
                    _deviceInfo = "<DeviceInfo>" +
                       "  <OutputFormat>EMF</OutputFormat>" +
                       "  <PageWidth>8.5in</PageWidth>" +
                       "  <PageHeight>11in</PageHeight>" +
                       "  <MarginTop>0.08in</MarginTop>" +
                       "  <MarginLeft>0.5in</MarginLeft>" +
                       "  <MarginRight>0.5in</MarginRight>" +
                       "  <MarginBottom>0.08in</MarginBottom>" +
                       "</DeviceInfo>";
                }
                else
                {
                    _deviceInfo = "<DeviceInfo>" +
                        "  <OutputFormat>EMF</OutputFormat>" +
                        "  <PageWidth>8.5in</PageWidth>" +
                        "  <PageHeight>11in</PageHeight>" +
                        "  <MarginTop>0.5in</MarginTop>" +
                        "  <MarginLeft>0.5in</MarginLeft>" +
                        "  <MarginRight>0.5in</MarginRight>" +
                        "  <MarginBottom>0.5in</MarginBottom>" +
                        "</DeviceInfo>";
                }
            }
        }

        /// <summary>
        /// Constructor CR 3306 For manualy printed reports pass printer settings that contain information about double sided printing
        /// </summary>
        /// <param name="printerSettings"></param>
        /// <param name="landscape"></param>
        /// <param name="report"></param>
        public VbecsReportPrinter(PrinterSettings printerSettings, bool landscape, LocalReport report)
        {
            _printerSettings = printerSettings;
            _landscape = landscape;
            _report = report;

            if (landscape)
            {
                _deviceInfo = "<DeviceInfo>" +
                              "  <OutputFormat>EMF</OutputFormat>" +
                              "  <PageWidth>11in</PageWidth>" +
                              "  <PageHeight>8.5in</PageHeight>" +
                              "  <MarginTop>0.5in</MarginTop>" +
                              "  <MarginLeft>0.5in</MarginLeft>" +
                              "  <MarginRight>0.5in</MarginRight>" +
                              "  <MarginBottom>0.5in</MarginBottom>" +
                              "</DeviceInfo>";
            }
            else
            {
                if (_report.DisplayName == "BTRF")
                {
                    _deviceInfo = "<DeviceInfo>" +
                       "  <OutputFormat>EMF</OutputFormat>" +
                       "  <PageWidth>8.5in</PageWidth>" +
                       "  <PageHeight>11in</PageHeight>" +
                       "  <MarginTop>0.08in</MarginTop>" +
                       "  <MarginLeft>0.5in</MarginLeft>" +
                       "  <MarginRight>0.5in</MarginRight>" +
                       "  <MarginBottom>0.08in</MarginBottom>" +
                       "</DeviceInfo>";
                }
                else
                {
                    _deviceInfo = "<DeviceInfo>" +
                        "  <OutputFormat>EMF</OutputFormat>" +
                        "  <PageWidth>8.5in</PageWidth>" +
                        "  <PageHeight>11in</PageHeight>" +
                        "  <MarginTop>0.5in</MarginTop>" +
                        "  <MarginLeft>0.5in</MarginLeft>" +
                        "  <MarginRight>0.5in</MarginRight>" +
                        "  <MarginBottom>0.5in</MarginBottom>" +
                        "</DeviceInfo>";
                }
            }
        }

        /// <summary>
        /// Print
        /// </summary>
        public void Print()
        {
            
            using (System.Security.Principal.WindowsImpersonationContext wic = System.Security.Principal.WindowsIdentity.Impersonate(IntPtr.Zero))
            {
                Warning[] warnings;
                _streams = new List<Stream>();

                //CR3562
                var permissions = new PermissionSet(PermissionState.Unrestricted);
                _report.SetBasePermissionsForSandboxAppDomain(permissions);
#pragma warning disable 618
                _report.ExecuteReportInSandboxAppDomain();
#pragma warning restore 618
                /**************************************************/

                _report.Render("Image", _deviceInfo, CreateStream, out warnings);
                foreach (Stream stream in _streams)
                    stream.Position = 0;

                _currentPageIndex = 0;

                if (_streams == null || _streams.Count == 0)
                    return;

                //*** Fortify Justified Code ***
                //Per Microsoft calling dispose on Printdocument releases all unmanaged resources.
                using (var printDoc = new PrintDocument())
                {
                    //CR 3306
                    if (_printerSettings != null)
                    {
                        printDoc.PrinterSettings = _printerSettings;
                    }
                    else
                    {
                        printDoc.PrinterSettings.PrinterName = _printerName;
                    }
                    printDoc.DefaultPageSettings.Landscape = _landscape;

                    if (!printDoc.PrinterSettings.IsValid)
                    {
                        //TODO: Add exception handling
                    }
                    printDoc.PrintPage += new PrintPageEventHandler(PrintPage);
                    printDoc.Print();
                }
                //*** Fortify Justified Code ***
            }
        }

        /// <summary>
        /// PrintPage
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="ev"></param>
        private void PrintPage(object sender, PrintPageEventArgs ev) 
        {
            Image pageImage = Image.FromStream(_streams[_currentPageIndex]);
            ev.Graphics.DrawImage(pageImage, ev.PageBounds); 
            _currentPageIndex++;
            ev.HasMorePages = (_currentPageIndex < _streams.Count);
        }

        private Stream CreateStream(string name, string fileNameExtension, Encoding encoding, string mimeType, bool willSeek)
        {
            Stream stream = new MemoryStream();
            _streams.Add(stream);
            return stream;
        }

        /// <summary>
        /// Dispose
        /// </summary>
        public void Dispose() 
        {
            if (_streams != null)
            {
                foreach (Stream stream in _streams)
                {
                    stream.Close();
                    stream.Dispose();
                }
            }
            GC.Collect();
        }
    }
}
